## Introduction to Discovery

- Discovery involves collecting host and user information by the Threat Defense device and storing it in the Management Center.
- Enables viewing host profiles for identifying vulnerabilities, assessing intrusion impacts, and tuning intrusion rules.

# Discovery Process

### Network Discovery Policy

- Defines which networks to discover and inspects traffic for host information.
- Information is passed to the Management Center, creating host profiles based on policy parameters.
- Requires defining network ranges for protection and creating host profiles for detected IPs.

### Discovery Functions

- Uses collected data for impact flags, intrusion analysis, IPS rule tuning, and incident investigation.
- **Passive Detection**: Automatic detection of host operating systems, clients, and applications.
- **Active Detection**: Utilizes active sources like Nmap for scanning hosts and discovering OS and services.

## Configuring Network Discovery Policy

- Controls how Management Center collects data on network assets and monitors network segments/ports.
- ACP defines traffic monitoring scope; blocked traffic is not monitored.
- Discovery rules tailor the network map data and are evaluated sequentially.

### Default Rule

- Discovers applications from all observed traffic and is deployed to managed devices by default.
- Modify or create additional rules to adjust discovery scope.

## Host Profiles

### Information Provided

- IP address, operating system, servers, clients, web applications, protocols, IOC tags, VLAN tags, user activity, malware events, vulnerabilities, and Nmap scan results.
- Accuracy is crucial for analysis and automation of security protection.

### Vulnerabilities

- Automatically assigned based on detected OS, applications, and services.
- Use the Vulnerability Database (VDB) for protecting networks and providing analysis functionality.

## Vulnerabilities in Host Profile

- Lists vulnerabilities affecting hosts based on detected OS, servers, and applications.
- Correlates data (intrusion, security intelligence, connection, file/malware events) to assess host compromise risk.
- IoC tags display threats, event details, and allow for tag management.